/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.dao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.mosp.human.dao.MKihonDao;
import jp.mosp.human.dto.MKihonDto;

public class MKihonPayrollDao extends MKihonDao {
	
	/**
	 * sB
	 */
	public MKihonPayrollDao() {
		super();
	}
	
	/**
	 * ʂ擾(DTOList)B
	 * @return List Xg
	 * @throws SQLException
	 */
	private List<MKihonDto> mappingAll() throws SQLException {
		List<MKihonDto> all = new ArrayList<MKihonDto>();
		while (rs.next()) {
			all.add(mapping());
		}
		return all;
	}

	/**
	 * ʂ擾(DTO)B
	 * @return m_kihonDto m_kihonR[h
	 * @throws SQLException
	 */
	private MKihonDto mapping() throws SQLException {
		MKihonDto dto = new MKihonDto();
		dto.setKCode		(rs.getString (COL_KCODE));		//ЈR[h
		dto.setSimei 		(rs.getString (COL_SIMEI));		//
		dto.setFurigana 	(rs.getString (COL_FURIGANA));	//ӂ肪
		dto.setSCode 		(rs.getString (COL_SCODE));		//R[h
		dto.setYCode 		(rs.getString (COL_YCODE));		//ER[h
		dto.setTokyu 		(rs.getString (COL_TOKYU));		//
		dto.setJCode 		(rs.getString (COL_JCODE));		//ƏR[h
		dto.setNyDate 		(rs.getInt    (COL_NYDATE));	//Г
		dto.setTsDate 		(rs.getInt    (COL_TSDATE));	//ސE
		dto.setKnKubun 		(rs.getString (COL_KNKUBUN));	//xސE敪
		dto.setKyKubun 		(rs.getString (COL_KYKUBUN));	//^敪
		dto.setTxKubun 		(rs.getString (COL_TXKUBUN));	//ŋ敪
		dto.setTxKubunx 	(rs.getString (COL_TXKUBUNX));	//̑ŋ敪
		dto.setKmKubun 		(rs.getString (COL_KMKUBUN));	//g敪
		dto.setPtKubun 		(rs.getString (COL_PTKUBUN));	//p[g敪
		dto.setShKubun 		(rs.getString (COL_SHKUBUN));	//x敪
		dto.setSiwakeCd 	(rs.getString (COL_SIWAKECD));	//dWvR[h
		dto.setHaigusya 	(rs.getString (COL_HAIGUSYA));	//}{z
		dto.setFuyosu 		(rs.getInt    (COL_FUYOSU));	//}{Ƒ
		dto.setYukyu 		(rs.getDouble (COL_YUKYU));		//Lc
		dto.setNenrei 		(rs.getInt    (COL_NENREI));	//N
		dto.setKinzoku 		(rs.getInt    (COL_KINZOKU));	//ΑN
		dto.setKenpoNo 		(rs.getString (COL_KENPONO));	//۔ԍ
		dto.setKohoNo 		(rs.getString (COL_KOHONO));	//۔ԍ
		dto.setKUser 		(rs.getString (COL_KUSER));		//[U
		dto.setPassw 		(rs.getString (COL_PASSW));		//pX[h
		dto.setEmail 		(rs.getString (COL_EMAIL));		//email
		dto.setNinsyo 		(rs.getString (COL_NINSYO));	//F؎
		dto.setDataLvl 		(rs.getInt    (COL_DATALVL));	//f[^x
		dto.setProgLevel 	(rs.getInt    (COL_PROGLEVEL));	//vOgp
		return dto;
	}
	
	/**
	 * ɂf[^擾B
	 * @param tsdate t
	 * @return List (DTOList)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public List<MKihonDto> find(
			int tsdate
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		index = 1;
		StringBuffer sb = new StringBuffer();
		sb.append("WHERE ");
		sb.append("(");
		sb.append(COL_TSDATE + " = 0 ");
		sb.append(" OR ");
		sb.append(COL_TSDATE + " >= ? ");
		sb.append(") ");
		sb.append(" ");
		try {
			prepareStatement(getSelectQuery(getClass()) + sb.toString() + getOrderForKey(getClass()));
			setParam(index++, tsdate);
			executeQuery();
			return mappingAll();
		} catch (SQLException e) {
			throw e;
		} finally {
			releaseResultSet();
			releasePreparedStatement();
		}
	}
	
}
